/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.animation.Animation;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.local.CacheAvatarLoader;
import org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import org.figuramc.figura.avatar.local.LocalAvatarLoader;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.config.ConfigManager;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.lua.api.ConfigAPI;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.resources.FiguraRuntimeResources;
import org.figuramc.figura.utils.FiguraClientCommandSource;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.IOUtils;
import org.figuramc.figura.utils.MathUtils;

class DebugCommand {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().serializeNulls().setPrettyPrinting().create();

    DebugCommand() {
    }

    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder debug = LiteralArgumentBuilder.literal((String)"debug");
        debug.executes(DebugCommand::commandAction);
        return debug;
    }

    private static int commandAction(CommandContext<FiguraClientCommandSource> context) {
        try {
            Path targetPath = FiguraMod.getFiguraDirectory().resolve("debug_data.json");
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createFile(targetPath, new FileAttribute[0]);
            }
            OutputStream fs = Files.newOutputStream(targetPath, new OpenOption[0]);
            fs.write(DebugCommand.fetchStatus(AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID())).getBytes());
            fs.close();
            ((FiguraClientCommandSource)context.getSource()).figura$sendFeedback((Component)FiguraText.of("command.debug.success").append(" ").append((Component)FiguraText.of("command.click_to_open").setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, targetPath.toString())).withUnderlined(Boolean.valueOf(true)))));
            return 1;
        }
        catch (Exception e) {
            ((FiguraClientCommandSource)context.getSource()).figura$sendError((Component)FiguraText.of("command.debug.error"));
            FiguraMod.LOGGER.error("Failed to save Figura debug data!", (Throwable)e);
            return 0;
        }
    }

    public static String fetchStatus(Avatar avatar) {
        JsonObject root = new JsonObject();
        JsonObject meta = new JsonObject();
        meta.addProperty("version", FiguraMod.VERSION.toString());
        meta.addProperty("localUUID", FiguraMod.getLocalPlayerUUID().toString());
        meta.addProperty("ticks", (Number)FiguraMod.ticks);
        meta.addProperty("figuraDirectory", FiguraMod.getFiguraDirectory().toString());
        meta.addProperty("figuraAvatarDirectory", LocalAvatarFetcher.getLocalAvatarDirectory().toString());
        meta.addProperty("figuraAvatarDataDirectory", ConfigAPI.getConfigDataDir().toString());
        meta.addProperty("figuraCacheDirectory", FiguraMod.getCacheDirectory().toString());
        meta.addProperty("figuraAvatarCacheDirectory", CacheAvatarLoader.getAvatarCacheDirectory().toString());
        meta.addProperty("figuraResourcesDirectory", FiguraRuntimeResources.getRootDirectory().toString());
        meta.addProperty("figuraAssetsDirectory", FiguraRuntimeResources.getAssetsDirectory().toString());
        meta.addProperty("backendStatus", (Number)NetworkStuff.backendStatus);
        meta.addProperty("backendConnected", Boolean.valueOf(NetworkStuff.isConnected()));
        meta.addProperty("backendDisconnectedReason", NetworkStuff.disconnectedReason);
        meta.addProperty("uploaded", Boolean.valueOf(AvatarManager.localUploaded));
        meta.addProperty("lastLoadedPath", Objects.toString(LocalAvatarLoader.getLastLoadedPath(), null));
        meta.addProperty("panicMode", Boolean.valueOf(AvatarManager.panic));
        root.add("meta", (JsonElement)meta);
        JsonObject config = new JsonObject();
        for (ConfigType<?> configType : ConfigManager.REGISTRY) {
            if (configType.value == null) continue;
            config.addProperty(configType.id, configType.value.toString());
        }
        root.add("config", (JsonElement)config);
        JsonObject permissions = new JsonObject();
        for (PermissionPack.CategoryPermissionPack group : PermissionManager.CATEGORIES.values()) {
            JsonObject allPermissions = new JsonObject();
            JsonObject standard = new JsonObject();
            for (Map.Entry<Permissions, Integer> entry : group.getPermissions().entrySet()) {
                standard.addProperty(entry.getKey().name, (Number)entry.getValue());
            }
            allPermissions.add("standard", (JsonElement)standard);
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<String, Map<Permissions, Integer>> entry3 : group.getCustomPermissions().entrySet()) {
                JsonObject obj = new JsonObject();
                for (Map.Entry<Permissions, Integer> entry1 : entry3.getValue().entrySet()) {
                    obj.addProperty(entry1.getKey().name, (Number)entry1.getValue());
                }
                jsonObject.add(entry3.getKey(), (JsonElement)obj);
            }
            allPermissions.add("custom", (JsonElement)jsonObject);
            permissions.add(group.name, (JsonElement)allPermissions);
        }
        root.add("permissions", (JsonElement)permissions);
        LocalAvatarFetcher.reloadAvatars().join();
        root.add("avatars", (JsonElement)DebugCommand.getAvatarsPaths(LocalAvatarFetcher.ALL_AVATARS));
        if (avatar == null) {
            return GSON.toJson((JsonElement)root);
        }
        JsonObject jsonObject = new JsonObject();
        JsonObject aPermissions = new JsonObject();
        aPermissions.addProperty("category", avatar.permissions.category.name);
        JsonObject standard = new JsonObject();
        for (Map.Entry entry : avatar.permissions.getPermissions().entrySet()) {
            standard.addProperty(((Permissions)entry.getKey()).name, (Number)entry.getValue());
        }
        aPermissions.add("standard", (JsonElement)standard);
        JsonObject customPermissions = new JsonObject();
        for (Map.Entry<String, Map<Permissions, Integer>> entry : avatar.permissions.getCustomPermissions().entrySet()) {
            JsonObject obj = new JsonObject();
            for (Map.Entry entry2 : entry.getValue().entrySet()) {
                obj.addProperty(((Permissions)entry2.getKey()).name, (Number)entry2.getValue());
            }
            customPermissions.add(entry.getKey(), (JsonElement)obj);
        }
        aPermissions.add("custom", (JsonElement)customPermissions);
        jsonObject.add("permissions", (JsonElement)aPermissions);
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.addProperty("version", avatar.version.toString());
        jsonObject2.addProperty("versionStatus", (Number)avatar.versionStatus);
        jsonObject2.addProperty("color", avatar.color);
        jsonObject2.addProperty("authors", avatar.authors);
        jsonObject2.addProperty("name", avatar.name);
        jsonObject2.addProperty("entityName", avatar.entityName);
        jsonObject2.addProperty("fileSize", (Number)avatar.fileSize);
        jsonObject2.addProperty("isHost", Boolean.valueOf(avatar.isHost));
        jsonObject2.addProperty("loaded", Boolean.valueOf(avatar.loaded));
        jsonObject2.addProperty("owner", avatar.owner.toString());
        jsonObject2.addProperty("scriptError", Boolean.valueOf(avatar.scriptError));
        jsonObject2.addProperty("hasTexture", Boolean.valueOf(avatar.hasTexture));
        jsonObject2.addProperty("hasLuaRuntime", Boolean.valueOf(avatar.luaRuntime != null));
        jsonObject2.addProperty("hasRenderer", Boolean.valueOf(avatar.renderer != null));
        jsonObject2.addProperty("hasData", Boolean.valueOf(avatar.nbt != null));
        for (Map.Entry<String, String> entry : avatar.badgeToColor.entrySet()) {
            jsonObject2.addProperty(entry.getKey(), entry.getValue());
        }
        jsonObject.add("meta", (JsonElement)jsonObject2);
        JsonObject jsonObject3 = new JsonObject();
        jsonObject3.addProperty("animationComplexity", (Number)avatar.animationComplexity);
        jsonObject3.addProperty("animationInstructions", (Number)avatar.animation.pre);
        jsonObject3.addProperty("complexity", (Number)avatar.complexity.pre);
        jsonObject3.addProperty("entityInitInstructions", (Number)avatar.init.post);
        jsonObject3.addProperty("entityRenderInstructions", (Number)avatar.render.pre);
        jsonObject3.addProperty("entityTickInstructions", (Number)avatar.tick.pre);
        jsonObject3.addProperty("initInstructions", (Number)avatar.init.pre);
        jsonObject3.addProperty("postEntityRenderInstructions", (Number)avatar.render.post);
        jsonObject3.addProperty("postWorldRenderInstructions", (Number)avatar.worldRender.post);
        jsonObject3.addProperty("worldRenderInstructions", (Number)avatar.worldRender.pre);
        jsonObject3.addProperty("worldTickInstructions", (Number)avatar.worldTick.pre);
        jsonObject3.addProperty("particlesRemaining", (Number)avatar.particlesRemaining.peek());
        jsonObject3.addProperty("soundsRemaining", (Number)avatar.soundsRemaining.peek());
        jsonObject.add("instructions", (JsonElement)jsonObject3);
        JsonArray sounds = new JsonArray();
        for (String string : avatar.customSounds.keySet()) {
            sounds.add(string);
        }
        jsonObject.add("sounds", (JsonElement)sounds);
        JsonArray animations = new JsonArray();
        for (Animation animation : avatar.animations.values()) {
            animations.add(animation.modelName + "/" + animation.name);
        }
        jsonObject.add("animations", (JsonElement)animations);
        if (avatar.nbt != null) {
            jsonObject.add("sizes", (JsonElement)DebugCommand.parseNbtSizes(avatar.nbt));
        }
        root.add("avatar", (JsonElement)jsonObject);
        return GSON.toJson((JsonElement)root);
    }

    private static JsonObject getAvatarsPaths(List<LocalAvatarFetcher.AvatarPath> list) {
        JsonObject avatar = new JsonObject();
        for (LocalAvatarFetcher.AvatarPath path : list) {
            String name = IOUtils.getFileNameOrEmpty(path.getPath());
            if (path instanceof LocalAvatarFetcher.FolderPath) {
                LocalAvatarFetcher.FolderPath folder = (LocalAvatarFetcher.FolderPath)path;
                avatar.add(name, (JsonElement)DebugCommand.getAvatarsPaths(folder.getChildren()));
                continue;
            }
            avatar.addProperty(name, path.getName());
        }
        return avatar;
    }

    private static JsonObject parseNbtSizes(CompoundTag nbt) {
        JsonObject sizes = new JsonObject();
        sizes.addProperty("metadata", DebugCommand.parseSize(DebugCommand.getBytesFromNbt((Tag)nbt.getCompound("metadata"))));
        CompoundTag modelsNbt = nbt.getCompound("models");
        ListTag childrenNbt = modelsNbt.getList("chld", 10);
        JsonObject models = DebugCommand.parseListSize(childrenNbt, tag -> tag.getString("name"));
        sizes.add("models", (JsonElement)models);
        sizes.addProperty("models_total", DebugCommand.parseSize(DebugCommand.getBytesFromNbt((Tag)modelsNbt)));
        ListTag animationsNbt = nbt.getList("animations", 10);
        JsonObject animations = DebugCommand.parseListSize(animationsNbt, tag -> tag.getString("mdl") + "." + tag.getString("name"));
        sizes.add("animations", (JsonElement)animations);
        sizes.addProperty("animations_total", DebugCommand.parseSize(DebugCommand.getBytesFromNbt((Tag)animationsNbt)));
        CompoundTag texturesNbt = nbt.getCompound("textures");
        CompoundTag textureSrc = texturesNbt.getCompound("src");
        JsonObject textures = DebugCommand.parseCompoundSize(textureSrc);
        sizes.add("textures", (JsonElement)textures);
        sizes.addProperty("textures_total", DebugCommand.parseSize(DebugCommand.getBytesFromNbt((Tag)texturesNbt)));
        CompoundTag scriptsNbt = nbt.getCompound("scripts");
        JsonObject scripts = DebugCommand.parseCompoundSize(scriptsNbt);
        sizes.add("scripts", (JsonElement)scripts);
        sizes.addProperty("scripts_total", DebugCommand.parseSize(DebugCommand.getBytesFromNbt((Tag)scriptsNbt)));
        CompoundTag soundsNbt = nbt.getCompound("sounds");
        JsonObject sounds = DebugCommand.parseCompoundSize(soundsNbt);
        sizes.add("sounds", (JsonElement)sounds);
        sizes.addProperty("sounds_total", DebugCommand.parseSize(DebugCommand.getBytesFromNbt((Tag)soundsNbt)));
        sizes.addProperty("total", DebugCommand.parseSize(DebugCommand.getBytesFromNbt((Tag)nbt)));
        return sizes;
    }

    private static int getBytesFromNbt(Tag nbt) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(baos)));
            NbtIo.writeUnnamedTag((Tag)nbt, (DataOutput)dos);
            dos.close();
            int size = baos.size();
            baos.close();
            return size;
        }
        catch (Exception ignored) {
            return -1;
        }
    }

    private static String parseSize(int size) {
        return size < 1000 ? size + "b" : MathUtils.asFileSize(size) + " (" + size + "b)";
    }

    private static JsonObject parseListSize(ListTag listNbt, Function<CompoundTag, String> function) {
        JsonObject target = new JsonObject();
        HashMap<String, Integer> sizesMap = new HashMap<String, Integer>();
        for (Tag tag : listNbt) {
            CompoundTag compound = (CompoundTag)tag;
            sizesMap.put(function.apply(compound), DebugCommand.getBytesFromNbt((Tag)compound));
        }
        DebugCommand.insertJsonSortedData(sizesMap, target);
        return target;
    }

    private static JsonObject parseCompoundSize(CompoundTag compoundNbt) {
        JsonObject target = new JsonObject();
        HashMap<String, Integer> sizesMap = new HashMap<String, Integer>();
        for (String key : compoundNbt.getAllKeys()) {
            sizesMap.put(key, DebugCommand.getBytesFromNbt(compoundNbt.get(key)));
        }
        DebugCommand.insertJsonSortedData(sizesMap, target);
        return target;
    }

    private static JsonElement parseTagRecursive(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            JsonObject obj = new JsonObject();
            HashMap<String, Integer> sizesMap = new HashMap<String, Integer>();
            for (String key : compoundTag.getAllKeys()) {
                JsonPrimitive size;
                JsonElement value = DebugCommand.parseTagRecursive(compoundTag.get(key));
                if (value instanceof JsonPrimitive && (size = (JsonPrimitive)value).isNumber()) {
                    sizesMap.put(key, size.getAsInt());
                    continue;
                }
                obj.add(key, value);
            }
            DebugCommand.insertJsonSortedData(sizesMap, obj);
            return obj;
        }
        return new JsonPrimitive((Number)DebugCommand.getBytesFromNbt(tag));
    }

    private static void insertJsonSortedData(HashMap<String, Integer> sizesMap, JsonObject json) {
        sizesMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(e -> json.addProperty((String)e.getKey(), DebugCommand.parseSize((Integer)e.getValue())));
    }
}

